/**
* @file    kS3dPhaseViewDecompressor.x.h
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef kS3D_PHASE_VIEW_DECOMPRESSOR_X_H
#define kS3D_PHASE_VIEW_DECOMPRESSOR_X_H

#define kS3D_PHASE_VIEW_PROCESSOR_REFERENCE_MAX_COUNT   (1)
#define kS3d_PHASE_VIEW_PROCESSOR_HIGH_FREQ_WINDOW_SIZE (5)

//Mai: threshold for phase correction
#define kS3D_PHASE_CORRECTION_DEFAULT_CONTRAST_THRESHOLD     (1)

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

typedef struct kS3dPhaseViewDecompressorExecutionTime
{
    kSize timeDecompressorEnd;
} kS3dPhaseViewDecompressorExecutionTime;

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

typedef struct kS3dPhaseViewDecompressorClass
{
    kObjectClass base;

    kBool complete;

    // Compression //
    kSize subframeCount;

    kS3dDecompressor decompressor;

    kArrayList subframeBuffer; // save subframes to delete later // async execution

    //Execution timing
    kTimer timer;
    kS3dPhaseViewDecompressorExecutionTime executionTime;

    //Outputs //
    kArray2 outputPhasePixel2;
} kS3dPhaseViewDecompressorClass;

kDeclareClassEx(kVs, kS3dPhaseViewDecompressor, kObject)

//////////////////////////////////////////////////////////////////////////
//semi-private exported functions (virtual override methods)
//////////////////////////////////////////////////////////////////////////

kVsFx(kStatus) kS3dPhaseViewDecompressor_VInitClone(kS3dPhaseViewDecompressor decompressor, kS3dPhaseViewDecompressor source, kAlloc allocator);
kVsFx(kStatus) kS3dPhaseViewDecompressor_VRelease(kS3dPhaseViewDecompressor decompressor);
kVsFx(kSize)   kS3dPhaseViewDecompressor_VSize(kS3dPhaseViewDecompressor decompressor);

//non-exported (private) methods
kStatus kS3dPhaseViewDecompressor_Init(kS3dPhaseViewDecompressor decompressor, kAlloc allocator);

//semi-private methods (API can change any time)
const kS3dPhaseViewDecompressorExecutionTime* kS3dPhaseViewDecompressor_ExecutionTime(kS3dPhaseViewDecompressor decompressor);
kStatus kS3dPhaseViewDecompressor_StartTimer(kS3dPhaseViewDecompressor decompressor);
kSize kS3dPhaseViewDecompressor_Elapsed(kS3dPhaseViewDecompressor decompressor);

//////////////////////////////////////////////////////////////////////////
//cast macro
//////////////////////////////////////////////////////////////////////////

#endif  /* #ifndef kS3D_PHASE_VIEW_DECOMPRESSOR_X_H */
