#ifndef LMITECH_KVISION_S3D_RECTIFIER_H_INCLUDED
#define LMITECH_KVISION_S3D_RECTIFIER_H_INCLUDED

#include <kVision/S3d/kS3dStereoCal.h>
#include <kVision/L3d/kL3dCommon.h>
#include <kVision/S3d/kS3dCommon.h>

typedef kPointer kS3dRectifier;

typedef kStatus(kCall* kS3dRectifierRemapFx)(kPointer context, k32s viewIndex, k32s x, k32s y, k32s* xr);


typedef struct kS3dRectifierParams 
{
    kRect64f worldRect;
    k64f xResolution;
    k64f yResolution;
    k32u widthGranularity;
    k32u heightGranularity;
} kS3dRectifierParams;

kVsFx(kStatus) kS3dRectifier_Construct(kS3dRectifier* rectifier, const kS3dRectifierParams* params, kS3dStereoCal cal);
kVsFx(kStatus) kS3dRectifier_Destroy(kS3dRectifier rectifier);

kVsFx(const kS3dRectifierParams*) kS3dRectifier_Parameters(kS3dRectifier rectifier);

kVsFx(k32u) kS3dRectifier_OutputWidth(kS3dRectifier rectifier);
kVsFx(k32u) kS3dRectifier_OutputHeight(kS3dRectifier rectifier);

kVsFx(k64f) kS3dRectifier_OutputX(kS3dRectifier rectifier, k32u viewIndex);
kVsFx(k64f) kS3dRectifier_OutputY(kS3dRectifier rectifier);

kVsFx(kStatus) kS3dRectifier_Run(kS3dRectifier rectifier, k32u viewIndex, kImage image, kImage output);
kVsFx(kStatus) kS3dRectifier_RunRemapped(kS3dRectifier rectifier, k32u viewIndex, kS3dRectifierRemapFx remapFx, kPointer remapContext, kImage image, kImage output);


kVsFx(kStatus) kS3dRectifier_XMap(kS3dRectifier rectifier, k32u viewIndex, kArray2* map);
kVsFx(kStatus) kS3dRectifier_YMap(kS3dRectifier rectifier, k32u viewIndex, kArray2* map);

#endif /* #define LMITECH_KVISION_S3D_RECTIFIER_H_INCLUDED */
