/**
* @file    kS3dSpeckleMatchAlg.x.h
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef KS3D_SPECKLE_MATCH_ALG_X_H
#define KS3D_SPECKLE_MATCH_ALG_X_H

#define kS3D_SPECKLE_MATCH_ALG_DEFAULT_BIT_DEPTH          (6)
#define kS3D_SPECKLE_MATCH_ALG_DEFAULT_MATCH_WINDOW       (5)
#define kS3D_SPECKLE_MATCH_ALG_DEFAULT_DISPARITY_RANGE    (128)
#define kS3D_SPECKLE_MATCH_ALG_DEFAULT_DISPARITY_CENTRE   (0)
#define kS3D_SPECKLE_MATCH_ALG_DEFAULT_LR_THRESHOLD       (2)
#define kS3D_SPECKLE_MATCH_ALG_DEFAULT_TEXTURE_THRESHOLD  (5)
#define kS3D_SPECKLE_MATCH_ALG_DEFAULT_UNIQUENESS_RATIO   (0.1)
#define kS3D_SPECKLE_MATCH_ALG_DEFAULT_CONTINUITY_WEIGHT  (1.0)
#define kS3D_SPECKLE_MATCH_ALG_DEFAULT_OCCLUSION_WEIGHT   (4.0)
#define kS3D_SPECKLE_MATCH_ALG_DEFAULT_FILTER_CAP         (127)

typedef struct kS3dSpeckleMatchAlgClass
{
    kObjectClass base;

    // Algorithm parameters
    kSize imageWidth;
    kSize imageHeight;
    k32u filterCap;
    k32u bitDepth;
    k32u matchWindow;
    k32u disparityRange;
    k32s disparityCentre;
    k32u disparityLrThreshold;
    k32u textureThreshold;
    k64f uniquenessRatio;
    k64f continuityWeight;
    k64f occlusionWeight;

} kS3dSpeckleMatchAlgClass;

typedef struct kS3dSpeckleMatchAlgVTable
{
    kObjectVTable base;
    kStatus(kCall* VSetupImpl)(kS3dSpeckleMatchAlg alg);
    kStatus(kCall* VRunImpl)(kS3dSpeckleMatchAlg alg, kImage image0, kImage image1, kArray2 disparity);
    k32u (kCall* VDisparityMarginImpl)(kS3dSpeckleMatchAlg alg);
    k32u (kCall* VDisparityRangeGranularityImpl)(kS3dSpeckleMatchAlg alg);
} kS3dSpeckleMatchAlgVTable;

kDeclareVirtualClassEx(kVs, kS3dSpeckleMatchAlg, kObject)

//semi-private exported functions (virtual override methods)

kVsFx(kStatus) kS3dSpeckleMatchAlg_VInitClone(kS3dSpeckleMatchAlg alg, kS3dSpeckleMatchAlg source, kAlloc allocator);
kVsFx(kStatus) kS3dSpeckleMatchAlg_VRelease(kS3dSpeckleMatchAlg alg);

kVsFx(kStatus) kS3dSpeckleMatchAlg_VRunImpl(kS3dSpeckleMatchAlg alg, kImage image0, kImage image1, kArray2 disparity);
kVsFx(kStatus) kS3dSpeckleMatchAlg_VSetupImpl(kS3dSpeckleMatchAlg alg);
kVsFx(k32u)    kS3dSpeckleMatchAlg_VDisparityMarginImpl(kS3dSpeckleMatchAlg alg);
kVsFx(k32u)    kS3dSpeckleMatchAlg_VDisparityRangeGranularityImpl(kS3dSpeckleMatchAlg alg);

//non-exported (private) methods
kStatus kS3dSpeckleMatchAlg_InitFields(kS3dSpeckleMatchAlg alg, kAlloc allocator);
void*   kS3dSpeckleMatchAlg_AlignPtr(kS3dSpeckleMatchAlg alg, void* p, kSize alignment);

//cast macro

#endif  /* #ifndef KS3D_SPECKLE_MATCH_ALG_X_H */
