#ifndef LMITECH_KVISION_S3D_STEREOCAL_H_INCLUDED
#define LMITECH_KVISION_S3D_STEREOCAL_H_INCLUDED

#include <kVision/S3d/kS3dCommon.h>

typedef kPointer kS3dStereoCal;

#define kS3D_STEREO_CAL_FILE_NAME         "StereoCal.kdat"

typedef struct kS3dStereoCalParams 
{
    k64f projectionResolution;

    k32u projectionXCount;
    k32u projectionXStep;

    k32u projectionYCount;
    k32u projectionYStep;

    k32s disparityXBegin;
    k32u disparityXStep;
    k32u disparityXCount;

    k32s disparityYBegin;
    k32u disparityYStep;
    k32u disparityYCount;

    k32u disparityDStep;
    k32u disparityCount;

    k32s phaseXBegin;
    k32u phaseXStep;
    k32u phaseXCount;

    k32s phaseYBegin;
    k32u phaseYStep;
    k32u phaseYCount;

    k32u phasePStep;
    k32u phaseCount0;
    k32u phaseCount1;

} kS3dStereoCalParams;

kVsFx(kStatus) kS3dStereoCal_Construct(kS3dStereoCal* cal, const kS3dStereoCalParams* params);
kVsFx(kStatus) kS3dStereoCal_Load(kS3dStereoCal* cal, const kChar* fileName);
kVsFx(kStatus) kS3dStereoCal_Store(kS3dStereoCal cal, const kChar* filename);
kVsFx(kStatus) kS3dStereoCal_LoadFromNode(kS3dStereoCal* cal, kNode node, const kChar* fileName);
kVsFx(kStatus) kS3dStereoCal_StoreToNode(kS3dStereoCal cal, kNode node, const kChar* filename);
kVsFx(kStatus) kS3dStereoCal_Destroy(kS3dStereoCal cal);

kVsFx(const kS3dStereoCalParams*) kS3dStereoCal_Parameters(kS3dStereoCal cal);

kVsFx(kStatus) kS3dStereoCal_SetId(kS3dStereoCal cal, k32u id);
kVsFx(k32u) kS3dStereoCal_Id(kS3dStereoCal cal);

kVsFx(kStatus) kS3dStereoCal_SetTimestamp(kS3dStereoCal cal, const kChar* timestamp);
kVsFx(const kChar*) kS3dStereoCal_Timestamp(kS3dStereoCal cal);

kVsFx(kStatus) kS3dStereoCal_SetTemperature(kS3dStereoCal cal, const k64f temperature);
kVsFx(k64f) kS3dStereoCal_Temperature(kS3dStereoCal cal);

kVsFx(kStatus) kS3dStereoCal_SetTransposeAt(kS3dStereoCal cal, kBool transpose, kSize viewIndex);
kVsFx(kBool) kS3dStereoCal_TransposeAt(kS3dStereoCal cal, kSize viewIndex);

kVsFx(kStatus) kS3dStereoCal_SetInvertXAt(kS3dStereoCal cal, kBool invertX, kSize viewIndex);
kVsFx(kBool) kS3dStereoCal_InvertXAt(kS3dStereoCal cal, kSize viewIndex);

kVsFx(kStatus) kS3dStereoCal_SetInvertYAt(kS3dStereoCal cal, kBool invertY, kSize viewIndex);
kVsFx(kBool) kS3dStereoCal_InvertYAt(kS3dStereoCal cal, kSize viewIndex);

kVsFx(kArray2) kS3dStereoCal_ProjectionX0(kS3dStereoCal cal);
kVsFx(kArray2) kS3dStereoCal_ProjectionY0(kS3dStereoCal cal);
kVsFx(kArray2) kS3dStereoCal_ProjectionX1(kS3dStereoCal cal);
kVsFx(kArray2) kS3dStereoCal_ProjectionY1(kS3dStereoCal cal);

kVsFx(kArray2) kS3dStereoCal_DisparityMap(kS3dStereoCal cal);
kVsFx(kArray1) kS3dStereoCal_DisparityToX(kS3dStereoCal cal);
kVsFx(kArray1) kS3dStereoCal_DisparityToY(kS3dStereoCal cal);
kVsFx(kArray1) kS3dStereoCal_DisparityToZ(kS3dStereoCal cal);

kVsFx(kArray2) kS3dStereoCal_PhaseMap0(kS3dStereoCal cal);
kVsFx(kArray1) kS3dStereoCal_PhaseToX0(kS3dStereoCal cal);
kVsFx(kArray1) kS3dStereoCal_PhaseToY0(kS3dStereoCal cal);
kVsFx(kArray1) kS3dStereoCal_PhaseToZ0(kS3dStereoCal cal);

kVsFx(kArray2) kS3dStereoCal_PhaseMap1(kS3dStereoCal cal);
kVsFx(kArray1) kS3dStereoCal_PhaseToX1(kS3dStereoCal cal);
kVsFx(kArray1) kS3dStereoCal_PhaseToY1(kS3dStereoCal cal);
kVsFx(kArray1) kS3dStereoCal_PhaseToZ1(kS3dStereoCal cal);

kVsFx(kBool) kS3dStereoCal_PhaseCalExists(kS3dStereoCal cal);

/**
* Returns the view index of the sensor stereo pair with lower X coordinate relative to the FOV of the sensor. For current sensor models with symmetric
* camera configuration the function can be used directly to determine how camera indices map to physical positions of the cameras.
*
* This function performs calculations every time it is called.
*/
kVsFx(kStatus) kS3dStereoCal_LeftViewIndex(kS3dStereoCal cal, kSize* viewIndex);

#include <kVision/S3d/kS3dStereoCal.x.h>

#endif  /* #ifndef LMITECH_KVISION_S3D_STEREOCAL_H_INCLUDED */
