/**
* @file    kS3dStereoProfiler.x.h
*
* @internal
* Copyright (C) 2018-2022 by LMI Technologies Inc.  All rights reserved.
*/
#ifndef K_VISION_S3D_STEREO_PROFILER_X_H
#define K_VISION_S3D_STEREO_PROFILER_X_H

//////////////////////////////////////////////////////////////////////////
// Class
//////////////////////////////////////////////////////////////////////////

typedef struct kS3dStereoProfilerClass
{
    kObjectClass base;

    kS3dStereoProfilerBase profiler;


} kS3dStereoProfilerClass;

kDeclareClassEx(kVs, kS3dStereoProfiler, kObject)

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

// virtual //
kVsFx(kStatus) xkS3dStereoProfiler_Init(kS3dStereoProfiler profiler, kS3dStereoProfilerType profilerType, const kS3dStereoProfilerParams* params, kS3dStereoCal cal, kAlloc allocator);
kVsFx(kStatus) xkS3dStereoProfiler_VInitClone(kS3dStereoProfiler profiler, kS3dStereoProfiler source, kAlloc allocator);
kVsFx(kStatus) xkS3dStereoProfiler_VRelease(kS3dStereoProfiler profiler);
kVsFx(kSize) xkS3dStereoProfiler_VSize(kS3dStereoProfiler profiler);

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kInlineFx(void) kS3dStereoProfiler_Rectify(kS3dStereoProfiler profiler, kSize viewIndex, k32s x, k32s y, k16s* xProj, k16s* yProj)
{    
    kObj(kS3dStereoProfiler, profiler);

    kS3dStereoProfilerHwContext_Rectify(kS3dStereoProfiler_HwContext(profiler), viewIndex, x, y, xProj, yProj);
}

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kInlineFx(void) kS3dStereoProfiler_RectifyLinear(kS3dStereoProfiler profiler, kSize viewIndex, k32s x, k32s y, k16s* xProj, k16s* yProj)
{
    kObj(kS3dStereoProfiler, profiler);

    kS3dStereoProfilerHwContext_RectifyLinear(kS3dStereoProfiler_HwContext(profiler), viewIndex, x, y, xProj, yProj);
}

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kInlineFx(void) kS3dStereoProfiler_LookupDisparity(kS3dStereoProfiler profiler, k16s xProj0, k16s xProj1, k16s yProj, kPoint3d16s* result)
{
    kObj(kS3dStereoProfiler, profiler);

    kS3dStereoProfilerHwContext_LookupDisparity(kS3dStereoProfiler_HwContext(profiler), xProj0, xProj1, yProj, result);
}

kInlineFx(void) kS3dStereoProfiler_LookupPhase(kS3dStereoProfiler profiler, kSize viewIndex, k16s xProj, k16s yProj, k32s phase, kPoint3d16s* result)
{
    kObj(kS3dStereoProfiler, profiler);

    kS3dStereoProfilerHwContext_LookupPhase(kS3dStereoProfiler_HwContext(profiler), viewIndex, xProj, xProj, phase, result);
}

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kInlineFx(kSize) kS3dStereoProfiler_MemoryUsage(kS3dStereoProfiler profiler)
{
    kObj(kS3dStereoProfiler, profiler);

    return kS3dStereoProfilerBase_MemoryUsage(obj->profiler);
}

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

kVsFx(kStatus) kS3dStereoProfiler_EvaluateImageDisparity64f(kS3dStereoProfiler profiler, kPoint64f* point0, kPoint64f* point1, kPoint3d64f* output);
kVsFx(kStatus) kS3dStereoProfiler_EvaluateImagePhase64f(kS3dStereoProfiler profiler, k32u viewIndex, kPoint64f* point, k64f phaseIndex, kPoint3d64f* output);
kVsFx(kStatus) kS3dStereoProfiler_RectificationError(kS3dStereoProfiler profiler, kPoint64f* imagePt0, kPoint64f* imagePt1, k64f* rectificationError);

//////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////

#endif // K_VISION_S3D_STEREO_PROFILER_X_H
