/**
* @file    kS3dVolumeCheckAlign.x.h
* @brief   Declares the kS3dVolumeCheckAlign class.
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_KS3D_VOLUMECHECKALIGN_X_H
#define KVISION_KS3D_VOLUMECHECKALIGN_X_H

#define KS3DVOLUMECHECKALIGN_VECTOR_SIZE  (3)
#define KS3DVOLUMECHECKALIGN_MATRIX_SIZE  (9)
#define KS3DVOLUMECHECKALIGN_SUM_COUNT  (8)

#define KS3DVOLUMECHECKALIGN_X   (0)
#define KS3DVOLUMECHECKALIGN_Y   (1)
#define KS3DVOLUMECHECKALIGN_XX  (2)
#define KS3DVOLUMECHECKALIGN_XY  (3)
#define KS3DVOLUMECHECKALIGN_YY  (4)
#define KS3DVOLUMECHECKALIGN_Z   (5)
#define KS3DVOLUMECHECKALIGN_ZX  (6)
#define KS3DVOLUMECHECKALIGN_ZY  (7)

#define KS3DVOLUMECHECKALIGN_FLUSH_INTERVAL   (10000)
#define KS3DVOLUMECHECKALIGN_ALIGN_STEP        (2)

#define KS3DVOLUMECHECKALIGN_ALIGN_TOL_RATE         (1.5)

#define KS3DVOLUMECHECKALIGN_FILTER_THRESHOLD         100   // fraction of the Z FOV
#define KS3DVOLUMECHECKALIGN_FILTER_MIN_THICK         10
#define KS3DVOLUMECHECKALIGN_DEPTH_THRESHOLD          (-0.4)
        
typedef enum kS3dVolumeCheckAlignAlignMode
{
    kS3D_VOLUME_CHECK_ALIGN_BALANCE = 0, //AG: fix caps and name duplication
    kS3D_VOLUME_CHECK_ALIGN_MAXIMUM,
    kS3D_VOLUME_CHECK_ALIGN_MINIMUM
} kS3dVolumeCheckAlignAlignMode;

typedef struct kS3dVolumeCheckAlignClass
{
    kObjectClass base;
    k64f rangeScale;  
    k16s maxRepeat;   
    kArray2 tempZ;  
    k32u height;  
    k32u width;   
    k32s z0;
    k32s dXX, dXY, dXZ;   
    k32s dYX, dYY, dYZ;   
    k32s dZX, dZY, dZZ;   

    k32s xmin;            
    k32s ymin;
    k32s zmin;   
    k32s xmax;
    k32s ymax;
    k32s zmax; 

    k64f Mat[KS3DVOLUMECHECKALIGN_MATRIX_SIZE];  
    k64f Vec[KS3DVOLUMECHECKALIGN_VECTOR_SIZE];  
    k64s Sum[KS3DVOLUMECHECKALIGN_SUM_COUNT];    
    k64f results[KS3DVOLUMECHECKALIGN_VECTOR_SIZE];  
    k32s count;  
    k32s a, b, c;  
    kArray2 data;   
    kArray2 valid;  
    kPoint3d64f center;
    k64f slopeAngle;
    k64f polarAngle;
    kS3dVolumeCheckSensorRotationMode rotationMode;
    k32s warningStatus;
} kS3dVolumeCheckAlignClass;

kDeclareClassEx(kVs, kS3dVolumeCheckAlign, kObject)

kStatus kS3dVolumeCheckAlign_Init(kS3dVolumeCheckAlign align, kType classType, kAlloc alloc);
kVsFx(kStatus) kS3dVolumeCheckAlign_VRelease(kS3dVolumeCheckAlign align);
kStatus kS3dVolumeCheckAlign_AlignInit(kS3dVolumeCheckAlign align);
kStatus kS3dVolumeCheckAlign_SumUpData(kS3dVolumeCheckAlign align);
kStatus kS3dVolumeCheckAlign_SolveTransformCoeffs(kS3dVolumeCheckAlign align);
kStatus kS3dVolumeCheckAlign_SegmentData(kS3dVolumeCheckAlign align, kS3dVolumeCheckAlignAlignMode mode);
kStatus kS3dVolumeCheckAlign_ResetTempData(kS3dVolumeCheckAlign align);
kStatus kS3dVolumeCheckAlign_SetAlignCoeffs(kS3dVolumeCheckAlign align);
kStatus kS3dVolumeCheckAlign_AlignDataMap(kS3dVolumeCheckAlign align, k32s depthTol);
kStatus kS3dVolumeCheckAlign_SegmentMapBottomRight(kS3dVolumeCheckAlign align, k32s xStart, k32s yStart, k32s xEnd, k32s yEnd);
kStatus kS3dVolumeCheckAlign_SegmentMapBottomLeft(kS3dVolumeCheckAlign align, k32s xStart, k32s yStart, k32s xEnd, k32s yEnd);
kStatus kS3dVolumeCheckAlign_SegmentMapTopLeft(kS3dVolumeCheckAlign align, k32s xStart, k32s yStart, k32s xEnd, k32s yEnd);
kStatus kS3dVolumeCheckAlign_SegmentMapTopRight(kS3dVolumeCheckAlign align, k32s xStart, k32s yStart, k32s xEnd, k32s yEnd);
kStatus kS3dVolumeCheckAlign_CheckSetup(kS3dVolumeCheckAlign align, kArray2 input);
kStatus kS3dVolumeCheckAlign_SetInputPoint3d16s(kS3dVolumeCheckAlign align, kArray2 input, k64f zScale);
kStatus kS3dVolumeCheckAlign_SetInputPoint3d32s(kS3dVolumeCheckAlign align, kArray2 input, k64f zScale);
kStatus kS3dVolumeCheckAlign_SetInputPoint3d32f(kS3dVolumeCheckAlign align, kArray2 input);
kStatus kS3dVolumeCheckAlign_SetInputPoint3d64f(kS3dVolumeCheckAlign align, kArray2 input);
kStatus kS3dVolumeCheckAlign_SetInputMap16s(kS3dVolumeCheckAlign align, kArray2 input, k64f xyScale, k64f zScale);
kStatus kS3dVolumeCheckAlign_SetInputMap32s(kS3dVolumeCheckAlign align, kArray2 input, k64f xyScale, k64f zScale);
kStatus kS3dVolumeCheckAlign_SetInputMap32f(kS3dVolumeCheckAlign align, kArray2 input, k64f xyScale);
kStatus kS3dVolumeCheckAlign_SetInputMap64f(kS3dVolumeCheckAlign align, kArray2 input, k64f xyScale);
kStatus kS3dVolumeCheckAlign_MatrixInvers3(k64f* srcMat, k64f* invMat);

#define KS3DVOLUMECHECKALIGN(HANDLE) ((kS3dVolumeCheckAlignClass*)(HANDLE))

#endif  /* #ifndef KVISION_KS3D_VOLUMECHECKALIGN_X_H */
