/**
* @file    kS3dVolumeCheckBlockInfo.x.h
* @brief   Declares the kS3dVolumeCheckBlock class.
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_KS3D_VOLUMECHECKBLOCKINFO_X_H
#define KVISION_KS3D_VOLUMECHECKBLOCKINFO_X_H

#include <kVision/S3d/kS3dVolumeCheckDef.h>
#include <kApi/Data/kArray1.h>
#include <kApi/Data/kXml.h>

typedef struct kS3dVolumeCheckBlockInfoClass 
{
    kObjectClass base;

    kS3dValveSettings   Valves[kS3D_VOLUMECHECK_VALVE_MAX];
    kS3dValveSettings   Sparks[kS3D_VOLUMECHECK_VALVE_MAX];
    kS3dVolumeCheckFilteringParams outlierFilter;
    kS3dVolumeCheckFilteringParams smoothFilter;
    kPoint64f chamberCenterOffset;
    k64f volumeOffset;
    k64f norminalVolume;
    k64f volumeTolerance;
    k64f valveSearchStep;
    k64f valveRadiusFactor;
    k64f correctFactor;
    kPoint3d64f inputScale;
    k64f inputZResolution;
    k32u outputSizeX;
    k32u outputSizeY;
    kPoint3d64f outputScale;
    k32u maxAlignRepeat;
    k32u maxRotationRepeat;
    k64f rotationTolerance;
    k64f moveTolerance;
    k32s contourAverageWindow;
    k32u valveCount;
    k32u sparkCount;
    kS3dVolumeCheckSensorRotationMode rotationMode;
    kS3dVolumeCheckDefaultChamberType chamberType;
    kS3dVolumeCheckSurfaceFrameOfReferenceType forType;
    kBool clearReport;
    kBool planeInfo;
    kBool offsetInfo;
    kBool transInfo;
    kBool valvesInfo;
    kBool timeInfo;
    kBool volumeInfo;

} kS3dVolumeCheckBlockInfoClass;

kDeclareClassEx(kVs, kS3dVolumeCheckBlockInfo, kObject)

kVsFx(kStatus) kS3dVolumeCheckBlockInfo_Init(kS3dVolumeCheckBlockInfo info, kType classType, kAlloc alloc);
kVsFx(kStatus) kS3dVolumeCheckBlockInfo_VRelease(kS3dVolumeCheckBlockInfo info);
kVsFx(kStatus) kS3dVolumeCheckBlockInfo_Release(kS3dVolumeCheckBlockInfo info);

#endif /* #ifndef KVISION_KS3D_VOLUMECHECKBLOCKINFO_X_H  */
