/**
* @file    kS3dVolumeCheckLowPass.h
* @brief   Some in volumeCheckApi used low pass filtering utilities. 
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc. All rights reserved.
*/

#ifndef KVISION_S3D_VOLUMCHECKLOWPASS_H
#define KVISION_S3D_VOLUMCHECKLOWPASS_H

#include <kVision/S3d/kS3dVolumeCheckUtilities.h>

/**
* Constructs a kS3dVolumeCheckAlg object
*
* @public              @memberof kS3dVolumeCheckLowPass
* @param   data        Height map of kArray2 < k32s > for the operation.
* @param   windowX     Window size for smooth filtering in x direction.
* @param   windowY     Window size for smooth filtering in y direction.
* @param   repeat      Repeat count for the smooth filtering
* @return              Operation status.
*/
kVsFx(kStatus) kS3dVolumCheckLowPass_GaussFilter32s(kArray2 data, k32s windowX, k32s windowY, k32s repeat);

/**
* Constructs a kS3dVolumeCheckAlg object
*
* @public              @memberof kS3dVolumeCheckLowPass
* @param   data        Height map of kArray2 < k32s > for the operation.
* @param   windowX     Window size for median filtering in x direction.
* @param   windowY     Window size for median filtering in y direction.
* @param   repeat      Repeat count for the median filtering
* @return              Operation status.
*/
kVsFx(kStatus) kS3dVolumCheckLowPass_MedianFilter32s(kArray2 data, k32s windowX, k32s windowY, k32s repeat);

/**
* Constructs a kS3dVolumeCheckAlg object
*
* @public              @memberof kS3dVolumeCheckLowPass
* @param   data        Height map of kArray2 < k32s > for the operation.
* @param   tolerance   Tolerance value to identify the outliers. Points within the tolerance range are not affected. 
* @param   windowX     Window size for Outlier filtering in x direction.
* @param   windowY     Window size for Outlier filtering in y direction.
* @param   repeat      Repeat count for the Outlier filtering
* @return              Operation status.
*/
kVsFx(kStatus) kS3dVolumCheckLowPass_OutliersFilter32s(kArray2 data, k32s tolerance, k32s windowX, k32s windowY, k32s repeat);

#endif /* #ifndef KVISION_S3D_VOLUMCHECKLOWPASS_H */
