#ifndef kVS_ANALOG_ADJUST_ACTION_H
#define kVS_ANALOG_ADJUST_ACTION_H

#include <kApi/kApi.h>
#include <kVision/Vs/kVsDef.h>
#include <kFireSync/Action/kAxAction.h>

/**
* The Analog Adjust Action loads either the AnalogAdjust.kdat file or the Adjust.xml file and applies a correction to the analog IO.
* There is one option for this action that determines which file to load.  
* - Auto - If the AnalogAdjust.kdat file exists, it loads this and applies correction.  
*          If it does not exist, but Adjust.xml exists and contains Analog Output correction information, it loads that applies the correction.
*          If neither exist, it does not apply a correction.
*          This will throw an error only if the number of channels in either AnalogAdjust.kdat or Adjust.xml do not match the number of channels for the sensor.
*          Note: Since some sensors do not have either AnalogAdjust.kdat or Adjust.xml files, it will not throw an error if these files are missing.
* - Dense LUT - This is the new method for correcting the analog output.
*             - Loads and applies the AnalogAdjust.kdat
*             - This will throw an error if the AnalogAdjust.kdat file does not exist or if the number of channels in the file does not match the number of channels of the sensor.
* - Linear - This is the old method for correcting the analog output
*             - Loads and applies the Adjust.xml
*             - This will throw an error if the Adjust.xml file does not exist, if the number of channels in the file does not match the number of channels of the sensor,
*               or if the adjust.xml file exists but does not contain any correction information.
* - None - This clears the calibration.
*        - This should never throw an error.
* 
*/

/**
* @class   kVsAnalogAdjustAction
* @ingroup kVision-Vs
* @brief   Used for action testing.
*/
typedef kAxAction kVsAnalogAdjustAction;

#include <kVision/Vs/kVsAnalogAdjustAction.x.h>

#endif
