/**
* @file    kVsBlackLevelAlg.x.h
*
* @internal
* Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
*/

#ifndef kVS_BLACK_LEVEL_ALG_X_H
#define kVS_BLACK_LEVEL_ALG_X_H

#include <math.h>
#include <kApi/Data/kArray1.h>
#include <kApi/Data/kArray2.h>
#include <kApi/Data/kArrayList.h>
#include <kApi/Data/kImage.h>
#include <kApi/Data/kMath.h>
#include <kVision/Vs/kVsUtilities.h>

#define kVS_BLACK_LEVEL_ALG_CAL_MIN_VALUE          (20)
#define kVS_BLACK_LEVEL_ALG_CAL_MAX_VALUE          (240)
#define kVS_BLACK_LEVEL_ALG_MIN_OUTPUT_VALUE       (0)
#define kVS_BLACK_LEVEL_ALG_MAX_OUTPUT_VALUE       (255)
#define kVS_BLACK_LEVEL_ALG_CAL_SKIP_COUNT         (1)
#define kVS_BLACK_LEVEL_ALG_CAL_STEP_COUNT         (10)
#define kVS_BLACK_LEVEL_ALG_VER_STEP_COUNT         (10)
#define kVS_BLACK_LEVEL_ALG_CAL_MIN_VALID_COUNT    (4)
#define kVS_BLACK_LEVEL_ALG_CAL_TARGET_INTENSITY   (-5)
#define kVS_BLACK_LEVEL_ALG_CAL_GROUND_THRESHOLD   (10)
#define kVS_BLACK_LEVEL_ALG_SLOPE_BOUND_PERCENT    (0.2)
#define kVS_BLACK_LEVEL_ALG_ADJACENT_DISTANCE_X    (2)
#define kVS_BLACK_LEVEL_ALG_ADJACENT_DISTANCE_Y    (2)

typedef struct kVsBlackLevelAlgClass{

    kObjectClass base;

    kAlloc alloc;

    //configuration parameters
    k64f targetGround;
    k64f groundThreshold;
    k32s blackLevelMax;
    k32s blackLevelMin;
    k64f slopeBoundPercent;
    kPoint32s adjacencyThreshold;

} kVsBlackLevelAlgClass;

kVsFx(kStatus) kVsBlackLevelAlg_Init(kVsBlackLevelAlg alg, kAlloc allocator);
kVsFx(kStatus) kVsBlackLevelAlg_VRelease(kVsBlackLevelAlg alg);

kVsFx(kStatus) kVsBlackLevelAlg_ImageAverageIntensity(kVsBlackLevelAlg alg, kImage image, k64f* intensity);
kVsFx(kStatus) kVsBlackLevelAlg_Covariance(kVsBlackLevelAlg alg, const kPoint64f* data, kSize dataCount, kPoint64f* centroidOut, k64f* angleOut, k64f* majorOut, k64f* minorOut, kArray2 covarianceMatrix);

kDeclareClassEx(kVs, kVsBlackLevelAlg, kObject)

#endif /* #ifndef kVS_BLACK_LEVEL_ALG_X_H */