/**
* @file kVsDynamicExposure.x.h


* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
*/

#ifndef K_VISION_DYNAMIC_EXPOSURE_X_H
#define K_VISION_DYNAMIC_EXPOSURE_X_H

#include <kVision/Vs/kVsDynamicExposure.h>
#include <kApi/Data/kArrayList.h>

typedef struct kVsDynamicExposureClass
{
    kObjectClass base;

    kArrayList pixSumThreshold;
    kArrayList adjustment;

    kSize minExposure;
    kSize maxExposure;
    kSize minSpotCount;

} kVsDynamicExposureClass;

kDeclareClassEx(kVs, kVsDynamicExposure , kObject)

kVsFx(kStatus) kVsDynamicExposure_VRelease(kVsDynamicExposure dynExp);
kVsFx(kStatus) kVsDynamicExposure_VInitClone(kVsDynamicExposure dynExp, kVsDynamicExposure source, kAlloc allocator);
kStatus kVsDynamicExposure_Init(kVsDynamicExposure dynExp, kArrayList pixSumThreshold, kArrayList adjustment, kAlloc allocator);
kStatus kVsDynamicExposure_Setup(kVsDynamicExposure dynExp);

#endif /* #ifndef K_VISION_DYNAMIC_EXPOSURE_X_H */
