/** 
 * @file    kVsModelDefStore.x.h
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_VISION_MODEL_DEF_STORE_X_H
#define K_VISION_MODEL_DEF_STORE_X_H

#include <kApi/Data/kArrayList.h>
#include <kApi/Data/kXml.h>
#include <kApi/Io/kPath.h>
#include <kVision/Vs/kVsModelDef.h>
#include <kVision/Vs/kVsXmlUtils.h>

#define kVS_MODEL_DEF_STORE_SYNTAX_MODELS_TAG            "Models"

#define kVS_MODEL_DEF_STORE_SYNTAX_PART_KEY                              "PartKey"
#define kVS_MODEL_DEF_STORE_SYNTAX_MODEL                                 "Model"
#define kVS_MODEL_DEF_STORE_SYNTAX_MODEL_NUMBER                          "ModelNumber"
#define kVS_MODEL_DEF_STORE_SYNTAX_FIRMWARE_VERSION                      "Version"
#define kVS_MODEL_DEF_STORE_SYNTAX_COMPATIBLE_FIRMWARE_TAG               "CompatibleFirmwareTag"
#define kVS_MODEL_DEF_STORE_DEFAULT_MODEL_FORMAT                         "Gocator_%s"


typedef struct kVsModelDefStoreClass 
{
    kObjectClass base;

    kArrayList models;
} kVsModelDefStoreClass;

kDeclareClassEx(kVs, kVsModelDefStore, kObject)

kVsFx(kStatus) kVsModelDefStore_VInitClone(kVsModelDefStore modelDefs, kVsModelDefStore source, kAlloc allocator);
kVsFx(kStatus) kVsModelDefStore_VRelease(kVsModelDefStore modelDefs);

kStatus kVsModelDefStore_Init(kVsModelDefStore modelDefs, const kChar* path, kAlloc allocator);
kStatus kVsModelDefStore_LoadXml(kVsModelDefStore modelDefs, const kChar* path);
kStatus kVsModelDefStore_FilterInputModelsByField(kVsModelDefStore modelDefStore, kArrayList inputModels, const kChar* fieldName, const kChar* fieldValue, kArrayList* models);

kBool kVsModelDefStore_DoStringsMatch(const kChar* a, const kChar* b, kChar* wildcard);

#endif  /* #ifndef K_VISION_INITIALIZER_X_H */
