/**
 * @file    kVsMovingAvg.x.h
 *
 * @internal
 * Copyright (C) 2015-2022 by LMI Technologies Inc.  All rights reserved.
 */
#ifndef K_VISION_MOVING_AVG_X_H
#define K_VISION_MOVING_AVG_X_H

#include <kVision/Common/kVision.h>

/**
* Default filter parameter settings.
*/

typedef struct kVsMovingAvgClass
{
    kVsImageFilterClass base;
} kVsMovingAvgClass;

kDeclareClassEx(kVs, kVsMovingAvg, kVsImageFilter)

//semi-private exported functions (virtual override methods)
kVsFx(kStatus) kVsMovingAvg_VRelease(kVsMovingAvg filter);
kVsFx(kStatus) kVsMovingAvg_VApply(kVsMovingAvg filter, kObject input, kObject output);
kVsFx(kStatus) kVsMovingAvg_VSetup(kVsMovingAvg filter);

//non-exported (private) methods
kVsFx(kStatus) kVsMovingAvg_Init(kVsMovingAvg filter, kType type, kAlloc allocator);
kVsFx(kStatus) kVsMovingAvg_Apply16s(kVsMovingAvg filter, const k16s* v, k16s* vOut, kSSize height, kSSize stride);
kVsFx(kStatus) kVsMovingAvg_Apply32s(kVsMovingAvg filter, const k32s* v, k32s* vOut, kSSize height, kSSize stride);
kVsFx(kStatus) kVsMovingAvg_Apply8u(kVsMovingAvg filter, const k8u* v, k8u* vOut, kSSize height, kSSize stride);
kVsFx(kStatus) kVsMovingAvg_Apply64f(kVsMovingAvg filter, const k64f* v, k64f* vOut, kSSize height, kSSize stride);

//cast macro

#endif   /* #ifndef K_VISION_MOVING_AVG_X_H */

