/**
* @file kVsSpline.x.h
*
* @internal
* Copyright (C) 2016-2022 by LMI Technologies Inc.  All rights reserved.
*/

#ifndef K_VISION_SPLINE_X_H
#define K_VISION_SPLINE_X_H

#include <kVision/Vs/kVsSpline.h>
#include <kVision/L3d/kL3dCommon.h>
#include <kVision/Vs/kVsDef.h>
#include <kApi/Data/kArray2.h>
#include <kApi/Data/kArray1.h>
#include <kApi/Data/kMath.h>
#include <kApi/kApiDef.h>

typedef struct kVsSplineClass
{
    kObjectClass base;
    kArray2 coefficients;
    kArray1 knots;
    k64f domain[2];
    kVsSplineType type;

} kVsSplineClass;

kDeclareClassEx(kVs, kVsSpline, kObject)

kStatus kVsSpline_Init(kVsSpline spline, kSize knotCount, kAlloc allocator);
kVsFx(kStatus) kVsSpline_VRelease(kVsSpline spline);

kVsFx(kStatus) kVsSpline_FitLinear(kVsSpline spline, const k64f* x, const k64f* f, kSize count);
kVsFx(kStatus) kVsSpline_FitCatmullRom(kVsSpline spline, const k64f* x, const k64f* f, kSize count);

/**
* Intepolate polynomials providing array of coefficients using Horner's method.
* 
*  The coefficients is required to start from lower order to higher order of the polynomial equation
*/
k64f kVsSpline_Interpolate(const k64f* coefficients, const k64f x, kSize order);

/**
* Quick sort and uniquify points base on point x value, output point count after uniquify
*
* At least 2 unique points are required to be a valid set of knot points
*/
kStatus kVsSpline_SortValidateKnots(const k64f* x, const k64f* f, kPoint64f* filteredPointData, kSize* filteredCount, kSize count);

#endif /* #ifndef K_VISION_SPLINE_X_H */
